﻿Public MustInherit Class GeometryWorldObject
    Inherits WorldObject

    Private _Geometry As Shape

    Public Property Texture As Texture2D
    Public Property Effect As BasicEffect

    Public ReadOnly Property Geometry As Shape
        Get
            Return Me._Geometry
        End Get
    End Property

    Sub New(game As Game, world As VirtualWorld, position As Vector3, rotation As Vector3, texture As Texture2D, shape As Shape, effect As BasicEffect)
        MyBase.new(game, world, position, rotation)
        Me._Texture = texture
        Me._Effect = effect
        Me._Geometry = shape
        'we need to update the bounding objects once the geometry has been specified
        Me.UpdateBoundingObjects()
    End Sub

    Sub New(game As Game, world As VirtualWorld, position As Vector3, rotation As Vector3, color As System.Drawing.Color, shape As Shape, effect As BasicEffect)
        Me.New(game, world, position, rotation, world.CreateColoredTexture(color, 500, 500), shape, effect)
    End Sub

    Protected Friend Overrides Sub UpdateBoundingBox()
        Me._BoundingBox = Me.Geometry.GetBoundingBoxForObject(Me)
    End Sub

    Public Overrides ReadOnly Property Size As Microsoft.Xna.Framework.Vector3
        Get
            Return Me.Geometry.Size
        End Get
    End Property

    Public Overrides Sub Draw(gameTime As Microsoft.Xna.Framework.GameTime)
        Me.BeginDraw(Me.World.ViewMatrix, Me.World.ProjectionMatrix, Me.GraphicsDevice, Me.Effect)
        Dim rotationYMatrix As Matrix = Matrix.CreateRotationY(MathHelper.ToRadians(Me.Rotation.Y))
        Dim rotationXMatrix As Matrix = Matrix.CreateRotationX(MathHelper.ToRadians(Me.Rotation.X))
        Dim rotationZMatrix As Matrix = Matrix.CreateRotationX(MathHelper.ToRadians(Me.Rotation.Z))
        Dim translateMatrix As Matrix = Matrix.CreateTranslation(Me.Position)
        Dim offsetMatrix As Matrix = Matrix.CreateTranslation(Me.RotationOffset)
        Dim worldMatrix As Matrix = Matrix.Identity * offsetMatrix * rotationYMatrix * rotationXMatrix * rotationZMatrix * translateMatrix
        Effect.World = worldMatrix
        Effect.View = Me.World.Camera.ViewMatrix
        Effect.Projection = Me.World.Camera.ProjectionMatrix
        Effect.TextureEnabled = True
        Effect.EnableDefaultLighting()
        Effect.PreferPerPixelLighting = True
        Effect.Texture = Me.Texture
        For Each pass As EffectPass In Effect.CurrentTechnique.Passes
            pass.Apply()
            Me.Geometry.Draw(Me.Game.GraphicsDevice)
        Next
        Me.EndDraw(Me.World.ViewMatrix, Me.World.ProjectionMatrix, Me.GraphicsDevice, Me.Effect)
        MyBase.Draw(gameTime)
    End Sub
End Class
